#include <iostream>
#include <vector>

using namespace std;

int addAllElements(const vector<int>& vec) {
    int sum = 0;
    for (int i = 0; i < vec.size(); ++i) {
        sum += vec[i];
    }
    return sum;
}

int countAppearancesOfAllElements(const vector<int>& vec) {
    int maxCount = 0;
    int n = vec.size();
    vector<int> count(n, 0);
    for (int i = 0; i < n; ++i) {
        count[vec[i]]++;
        if (count[vec[i]] > maxCount) {
            maxCount = count[vec[i]];
        }
    }
    return maxCount;

}


template <typename T>
vector<vector<T>> getAllSubarrays(const vector<T>& vec) {
    vector<vector<T>> result;
    int n = vec.size();
    // Spoljašnja petlja za pocetak podniza
    for (int i = 0; i < n; ++i) {
        // Unutrašnja petlja za kraj podniza
        for (int j = i; j < n; ++j) {
            vector<T> subarray;
            for (int k = i; k <= j; ++k) {
                subarray.push_back(vec[k]);
            }
            result.push_back(subarray);
        }
    }
    return result;
}

int main() {
    int n;
    cin >> n;
    vector<int> vec(n);
    for (int i = 0; i < n; ++i) {
        cin >> vec[i];
    }
    vector<vector<int>> subarrays = getAllSubarrays(vec);
    int minCount = 0;
    for (const auto& subarray : subarrays) {
        int sum = addAllElements(subarray);
        if (sum==0){
            int c = countAppearancesOfAllElements(subarray);
            if (c > minCount) {
                minCount = c;
            }
        }
    }

    cout << minCount << endl;

    return 0;
}